xhtml = '''
<?xml version='1.0' encoding='utf-8'?>
<!DOCTYPE html>
<html xmlns='http://www.w3.org/1999/xhtml'>
    {html}
</html>
'''.lstrip()

html = '''
<head>
    <title>{dc_title}</title>
    {stylelinks}
</head>
<body>
    {file}
</body>
'''.strip()

container_xml = '''
<?xml version='1.0' encoding='utf-8'?>
<container version='1.0'
           xmlns='urn:oasis:names:tc:opendocument:xmlns:container'>
    <rootfiles>
        <rootfile full-path='package.opf'
                  media-type='application/oebps-package+xml'/>
    </rootfiles>
</container>
'''.lstrip()

package_opf = '''
<?xml version='1.0' encoding='utf-8'?>
<package version='3.0' xmlns='http://www.idpf.org/2007/opf'
         unique-identifier='pub-id'>
    <metadata xmlns:dc='http://purl.org/dc/elements/1.1/'>
        <dc:identifier id='pub-id'>
            {dc_identifier}
        </dc:identifier>
        <dc:title>{dc_title}</dc:title>
        <dc:language>{dc_language}</dc:language>
        <dc:format>{dc_format}</dc:format>
        {dc_extra}
        <meta property='dcterms:modified'>{dcterms_modified}</meta>
    </metadata>

    <manifest>
        {manifestitems}
    </manifest>

    <spine>
        {spineitems}
    </spine>
</package>
'''.lstrip()

toc = '''
<?xml version='1.0' encoding='utf-8'?>
<!DOCTYPE html>
<html xmlns='http://www.w3.org/1999/xhtml'
      xmlns:epub='http://www.idpf.org/2007/ops'>
<head>
    <title>{dc_title}</title>
</head>
<body>
    {nav}
</body>
</html>
'''.lstrip()

nav = '''
<nav epub:type='toc'>
    {file}
</nav>
'''.strip()

mimetype = 'application/epub+zip'
