mimetypes = {'png': 'image/png',
             'jpg': 'image/jpeg',
             'jpeg': 'image/jpeg',
             'gif': 'image/gif',
             'svg': 'image/svg+xml',
             'webp': 'image/webp',
             'mp3': 'audio/mpeg',
             'mp4': 'audio/mp4',
             'ogg': 'audio/ogg',
             'ttf': 'font/ttf',
             'otf': 'font/otf',
             'woff': 'font/woff',
             'woff2': 'font/woff2',
             'xhtml': 'application/xhtml+xml',
             'css': 'text/css',
             'js': 'text/javascript',
             'smil': 'application/smil+xml'}

def get_basename(fpath):
    return fpath.split('/')[-1]

def get_extension(fpath):
    name = get_basename(fpath)
    return name.split('.')[-1]

def get_mimetype(fpath):
    extension = get_extension(fpath)
    return mimetypes[extension.lower()]
