import build_system

build_dir = 'build'

def page_fpath(page_path):
    if page_path[-1] == '/':
        return f'{build_dir}{page_path}index.html'
    else:
        return f'{build_dir}{page_path}'

def add_build_clean_rules(build):
    build.add_rule('build', phony=True)
    rule = build.add_rule('clean', phony=True)
    rule.add_command_args('rm', '-rf', build_dir)
    rule.add_command_args('mkdir', build_dir)
    rule.add_command_args('touch', f'{build_dir}/.gitkeep')

pages = dict()

# function to create a general page rule
def page_rule(build, page_title, page_path, *deps):
    fpath = page_fpath(page_path)
    rule = build.add_rule(fpath, *deps)
    build.add_deps('build', fpath)

    global pages
    pages[page_title] = page_path

    return rule
