import build_system
import boilerplate
import site_build

import blog
import rss_feed
import yt_archive

import sys

b = build_system.Build()
site_build.add_build_clean_rules(b)

# build css stylesheet by copying
r = b.add_rule('build/style.css', 'src/style.css')
r.add_command_args('cp', r.deps[0], r.target)
b.add_deps('build', r.target)

boilerplate.simple_rule(b, 'Home', '/', 'src/home.html', years='2025')
boilerplate.simple_rule(b, 'Contact', '/contact/',
                        'src/contact.html', years='2025')
boilerplate.simple_rule(b, 'Honours Thesis', '/honours/',
                        'src/honours.html', years='2024-2025')

r = boilerplate.generated_rule(b, 'YouTube Archive', '/youtube/',
    'src/yt_archive/page.htmlfmt', 'src/yt_archive/video.htmlfmt',
    'src/yt_archive/description.htmlfmt', 'data/video_info.json',
    years='2015-2025')
r.add_function(yt_archive.func, *r.deps)

blog.add_blog_rules(b, 'src/blog/blog.htmlfmt',
    'src/blog/post_listing.htmlfmt', 'src/blog/post.htmlfmt',
    'data/blog_posts.json', years='2025')

rss_feed.add_rss_rule(b, 'build/rss.xml', 'src/rss/feed.xmlfmt',
    'src/rss/item.xmlfmt', 'src/rss/items.json', 'data/blog_posts.json')

boilerplate.add_navigation('Home', 'Contact', 'Blog', 'YouTube Archive')

b.make(sys.argv[1])
