import build_system
import boilerplate
import site_build

import datetime
import json

def get_blog_post_info(blog_data_fpath):
    with open(blog_data_fpath, 'r') as f:
        data = json.load(f)

    for post in data:
        urlbase = post['urlbase']
        post['url'] = f'/blog/{urlbase}/'
        date = post['date']
        post['date'] = datetime.datetime.fromisoformat(date)

    return data

def _blog_list_func(blog_htmlfmt_fpath,
    post_listing_htmlfmt_fpath, sorted_posts):
    
    with open(blog_htmlfmt_fpath, 'r') as f:
        blog_htmlfmt = f.read()
    with open(post_listing_htmlfmt_fpath, 'r') as f:
        post_listing_htmlfmt = f.read()

    post_listings = []
    for post in sorted_posts:
        url = post['url']
        title = post['title']
        date = post['date']
        date_str = date.strftime('%-d %B %Y')
        description = post['description']
        post_listing = post_listing_htmlfmt.format(url=url,
            title=title, date=date_str, description=description)
        post_listings.append(post_listing)

    post_list = ''.join(post_listings)
    blog_list_html = blog_htmlfmt.format(post_list=post_list)
    return blog_list_html

def _blog_post_func(post_htmlfmt_fpath, post_fpath, post_info):
    with open(post_htmlfmt_fpath, 'r') as f:
        post_htmlfmt = f.read()
    with open(post_fpath, 'r') as f:
        post = f.read()

    title = post_info['title']
    date = post_info['date']
    date_str = date.strftime('%-d %B %Y')
    post_html = post_htmlfmt.format(title=title, date=date_str, post=post)
    return post_html

def add_blog_rules(b, blog_htmlfmt_fpath, post_listing_htmlfmt_fpath,
                   post_htmlfmt_fpath, blog_data_fpath, years):
    posts = get_blog_post_info(blog_data_fpath)
    sorted_posts = sorted(posts, key=lambda post: post['date'], reverse=True)

    r = boilerplate.generated_rule(b, 'Blog', '/blog/', blog_htmlfmt_fpath,
            post_listing_htmlfmt_fpath, blog_data_fpath, years=years)
    r.add_function(_blog_list_func, blog_htmlfmt_fpath,
        post_listing_htmlfmt_fpath, sorted_posts)

    for post_info in sorted_posts:
        title = post_info['title']
        pagetitle = f'{title} - Blog'
        url = post_info['url']
        date = post_info['date']
        year = date.year
        post_fpath = post_info['file']

        r = boilerplate.generated_rule(b, pagetitle, url, post_htmlfmt_fpath,
            post_fpath, years=year)
        r.add_function(_blog_post_func, post_htmlfmt_fpath,
                       post_fpath, post_info)
