import datetime
import html
import json

import boilerplate

htmlfmt_fpath = 'src/yt_archive/page.htmlfmt'
video_htmlfmt_fpath = 'src/yt_archive/video.htmlfmt'
description_htmlfmt_fpath = 'src/yt_archive/description.htmlfmt'
video_info_fpath = 'data/video_info.json'
head_html_fpath = 'src/yt_archive/head.html'

def _gen_video_entry(video_htmlfmt, description_htmlfmt, i, info):
    title = info['title']
    sanitised_title = html.escape(title)

    if info['is_public']:
        unlisted = ''
    else:
        unlisted = '(Unlisted)'

    unix_time = info['datetime']
    t = datetime.datetime.fromtimestamp(unix_time, datetime.timezone.utc)
    date = t.strftime('%-d %B %Y')

    duration = int(info['duration'])
    secs = duration % 60
    mins = (duration // 60) % 60
    hrs = duration // 3600
    if hrs < 1:
        duration_str = f'{mins}:{secs:02d}'
    else:
        duration_str = f'{hrs}:{mins:02d}:{secs:02d}'

    filename = info['filename']
    width = info['width']
    height = info['height']
    filesize = info['filesize']

    description = info['description']
    if len(description) == 0:
        description_html = '(No description)'
    else:
        description_html = description_htmlfmt.format(
            description=html.escape(description))

    return video_htmlfmt.format(i=i, title=sanitised_title, unlisted=unlisted,
        date=date, duration=duration_str, fname=filename, width=width,
        height=height, filesize=f'{filesize:,}',
        description_details=description_html)

def _gen_video_table(video_htmlfmt, description_htmlfmt, video_info):
    sorted_video_ids = sorted(video_info.keys(),
        key=lambda i: video_info[i]['datetime'], reverse=True)

    video_htmls = []
    for i in sorted_video_ids:
        info = video_info[i]
        video_html = _gen_video_entry(video_htmlfmt,
            description_htmlfmt, i, info)
        video_htmls.append(video_html)

    video_table = '\n'.join(video_htmls)
    return video_table

def _func(htmlfmt_fpath, video_htmlfmt_fpath,
         description_htmlfmt_fpath, video_info_fpath):
    with open(video_info_fpath, 'r') as f:
        video_info = json.load(f)
    with open(video_htmlfmt_fpath, 'r') as f:
        video_htmlfmt = f.read()
    with open(description_htmlfmt_fpath, 'r') as f:
        description_htmlfmt = f.read()
    video_table = _gen_video_table(video_htmlfmt,
        description_htmlfmt, video_info)

    with open(htmlfmt_fpath, 'r') as f:
        htmlfmt = f.read()
    body_html = htmlfmt.format(video_table=video_table)
    return body_html

def add_yt_archive_rule(build, pagetitle):
    r = boilerplate.generated_rule(build, pagetitle, '/youtube/',
        htmlfmt_fpath, video_htmlfmt_fpath, description_htmlfmt_fpath,
        video_info_fpath, years='2015-2025', head_src=head_html_fpath)
    r.add_function(_func, *r.deps)
