import build_system
import helper

import dochint

build_dir = 'build'

def page_fpath(page_path):
    if page_path[-1] == '/':
        return f'{build_dir}{page_path}index.html'
    else:
        return f'{build_dir}{page_path}'

def add_build_clean_rules(build):
    build.add_rule('build', phony=True)
    rule = build.add_rule('clean', phony=True)
    rule.add_command_args('rm', '-rf', build_dir)
    rule.add_command_args('mkdir', build_dir)
    rule.add_command_args('touch', f'{build_dir}/.gitkeep')

pages = dict()

def _page_rule(build, page_title, page_path, *deps):
    fpath = page_fpath(page_path)
    rule = build.add_rule(fpath, *deps)
    build.add_deps('build', fpath)

    global pages
    pages[page_title] = page_path

    return rule

def simple_rule(build, page_title, page_path, page_src):
    rule = _page_rule(build, page_title, page_path, page_src)
    page_fpath = rule.target
    
    def page_func():
        with open(page_src, 'r') as f:
            page_html = f.read()
        page_html_processed = dochint.process_text(page_html)
        f = helper.path_open_write(page_fpath)
        f.write(page_html_processed)
        f.close()

    rule.add_function(page_func)

def _clear_file(fpath):
    f = helper.path_open_write(fpath)
    f.close()

def generated_rule(build, page_title, page_path, *deps):
    class RuleWrapper:
        def __init__(self, rule):
            self._rule = rule
            self.target = rule.target
            self.deps = deps
            self.is_phony = False

            self._rule.add_function(_clear_file, self.target)

        def add_function(self, func, *args, **kwargs):
            def rule_func():
                page_html = func(*args, **kwargs)
                page_html_processed = dochint.process_text(page_html)

                with open(self.target, 'w+') as f:
                    f.write(page_html_processed)

            self._rule.add_function(rule_func)

    rule = _page_rule(build, page_title, page_path, *deps)
    return RuleWrapper(rule)
