import build_system
import boilerplate
import site_build

import blog
import rss_feed
import software
import yt_archive

import sys

b = build_system.Build()
site_build.add_build_clean_rules(b)

# build css stylesheet by copying
r = b.add_rule('build/style.css', 'src/style.css')
r.add_command_args('cp', r.deps[0], r.target)
b.add_deps('build', r.target)

boilerplate.simple_rule(b, 'Home', '/', 'src/home.html', years='2025-2026')
boilerplate.simple_rule(b, 'Contact', '/contact/',
                        'src/contact.html', years='2025')
boilerplate.simple_rule(b, 'Honours Thesis', '/honours/',
                        'src/honours.html', years='2024-2025')
boilerplate.simple_rule(b, 'What are RSS feeds? And why should you use them?',
    '/rss-explainer/', 'src/rss_explainer.html', years='2025')
boilerplate.simple_rule(b, 'Website Source', '/source/',
                        'src/source.html', years='2015-2025')

yt_archive.add_yt_archive_rule(b, 'YouTube Archive')

blog.add_blog_rules(b, 'Blog')

software.add_software_rules(b, 'Software')

rss_feed.add_rss_rule(b)

boilerplate.add_navigation('Home', 'Contact', 'Blog', 'Software')

b.make(sys.argv[1])
