import build_system
import boilerplate
import helper
import site_build

import datetime
import json

blog_htmlfmt_fpath = 'src/blog/blog.htmlfmt'
post_listing_htmlfmt_fpath = 'src/blog/post_listing.htmlfmt'
post_htmlfmt_fpath = 'src/blog/post.htmlfmt'
blog_data_fpath = 'data/blog_posts.json'

date_raw_fmt = '%Y-%m-%dT%H:%M:%S%z'
date_pretty_fmt = '%-d&nbsp;%B&nbsp;%Y'

def get_blog_post_info(blog_data_fpath):
    with open(blog_data_fpath, 'r') as f:
        data = json.load(f)

    for post in data:
        urlbase = post['urlbase']
        post['url'] = f'/blog/{urlbase}/'
        date = post['date']
        post['date'] = datetime.datetime.fromisoformat(date)

    return data

def _blog_list_func(blog_htmlfmt_fpath,
    post_listing_htmlfmt_fpath, sorted_posts):
    
    with open(blog_htmlfmt_fpath, 'r') as f:
        blog_htmlfmt = f.read()
    with open(post_listing_htmlfmt_fpath, 'r') as f:
        post_listing_htmlfmt = f.read()

    post_listings = []
    for post in sorted_posts:
        url = post['url']
        title = post['title']
        date = post['date']
        date_raw = date.strftime(date_raw_fmt)
        date_pretty = date.strftime(date_pretty_fmt)
        description = post['description']
        post_listing = post_listing_htmlfmt.format(url=url, title=title,
            date_raw=date_raw, date_pretty=date_pretty,
            description=description)
        post_listings.append(post_listing)

    post_list = ''.join(post_listings)
    blog_list_html = blog_htmlfmt.format(post_list=post_list)
    return blog_list_html

def _blog_post_func(post_htmlfmt_fpath, post_fpath, post_info):
    with open(post_htmlfmt_fpath, 'r') as f:
        post_htmlfmt = f.read()
    with open(post_fpath, 'r') as f:
        post = f.read()

    title = post_info['title']
    date = post_info['date']
    date_raw = date.strftime(date_raw_fmt)
    date_pretty = date.strftime(date_pretty_fmt)
    description = post_info['description']
    post_html = post_htmlfmt.format(title=title, description=description,
        date_raw=date_raw, date_pretty=date_pretty, post=post)
    return post_html

def add_blog_rules(build, pagetitle):
    posts = get_blog_post_info(blog_data_fpath)
    sorted_posts = sorted(posts, key=lambda post: post['date'], reverse=True)
    years = helper.year_range(sorted_posts[0]['date'],
                              sorted_posts[-1]['date'])

    r = boilerplate.generated_rule(build, pagetitle, '/blog/',
        blog_htmlfmt_fpath, post_listing_htmlfmt_fpath,
        blog_data_fpath, years=years)
    r.add_function(_blog_list_func, blog_htmlfmt_fpath,
        post_listing_htmlfmt_fpath, sorted_posts)

    for post_info in sorted_posts:
        title = post_info['title']
        pagetitle = f'{title} - Blog'
        url = post_info['url']
        date = post_info['date']
        year = date.year
        post_fpath = post_info['file']

        r = boilerplate.generated_rule(build, pagetitle, url,
            post_htmlfmt_fpath, post_fpath, years=year)
        r.add_function(_blog_post_func, post_htmlfmt_fpath,
                       post_fpath, post_info)
